/*******************************************************
	Author: 
		Liu Caiquan
	Date: 
		@17th-June-2016@

	CarLife Protocol version:
		@V1.0.12@
							Copyright (C) Under BaiDu, Inc.
*******************************************************/
#include <cstring>
#include "ASocketConnector.h"
#include "CCarLifeLog.h"
#include "CCarLifeLib.h"
// all the logging messages in this file are replaced to DLT by ADIT
LOG_IMPORT_CONTEXT(bdcl_core) //added by ADIT

#define MAX_READ                        4096 //modified by ADIT
using namespace std;

ASocketConnector::ASocketConnector(IProtocolSocketConnector* inProtocolSocketConnector,
		u8 inChannelId)
{

    iProtocolSocketConnector = inProtocolSocketConnector;
    channelId = inChannelId;

}
ASocketConnector::ASocketConnector(string serverIP, u32 port, string interfaceName)
{
    if(serverIP.find(":",0)!=string::npos){
	LOGD_DEBUG((bdcl_core,"iSockset=&socketv6"));
	iSockset=&socketv6;
    }else{
    	LOGD_DEBUG((bdcl_core,"iSockset=&socket"));
    	iSockset=&socket;
    }
	
    setConnectStatus(false);

    mdServerIP = serverIP;
    mdServerPort = port;
    networkCardInterfaceName=interfaceName;
}
ASocketConnector::~ASocketConnector()
{

}

bool ASocketConnector::getConnectStatus()
{
    return isConnected;
}

bool ASocketConnector::connectToServer()
{
    if (!iSockset->create())
    {
        LOG_ERROR((bdcl_core,"socket.create fail!"));
        return false;
    }

    if (!iSockset->connect(mdServerIP, mdServerPort, networkCardInterfaceName))
    {
        LOGD_DEBUG((bdcl_core,"mdServerIP: %s",mdServerIP.c_str()));
        LOGD_DEBUG((bdcl_core,"mdServerPort: %d",mdServerPort));

        LOG_ERROR((bdcl_core,"socket.connect fail!"));
        return false;
    }
    setConnectStatus(true);
    return true;
}

bool ASocketConnector::recv(u8* outData, u32 inLen)
{
    if(CCarLifeLib::getInstance()->cCarLifeActive)
     {

        if (iProtocolSocketConnector->getData(inLen, channelId, outData))
        {
            return true;
        }
     }

    return false;
}


bool ASocketConnector::send(u8* inData, u32 inLen)
{

    if (NULL == iProtocolSocketConnector)
    {
        LOG_ERROR((bdcl_core,"iProtocolSocketConnector is null"));
        return false;
    }

    if(!(CCarLifeLib::getInstance()->cCarLifeActive))
    {
        LOGD_DEBUG((bdcl_core,"socket send failed cCarLifeActive is false"));
        return false;
    }

    if (!iProtocolSocketConnector->send(inData, inLen, channelId))
    {
        LOG_ERROR((bdcl_core,"socket.send is failed"));
        return false;
    }
    return true;
}

